# Programma che calcola il numero di Fibonacci di un intero
# tramite un'algoritmo ricorsivo:
# fib(n) = fib(n-1) + fib (n-2) se n > 2
#        = 1                    se n = 1,2
# Ex: fib(1)=1, fib(2)=1, fib(3)=2, fib(4)=3, 5, 8, 13, ....
# Dimostrativo dell'uso dello stack.

        .data
prompt: .asciiz "Inserire un numero intero: "
output: .asciiz "Numero di Fibonacci: "
        .text
        .globl main
main:
        li $v0, 4           # stampa la stringa di prompt
        la $a0, prompt
        syscall
        li $v0, 5           # legge un intero da tastiera
        syscall
        move $s0 , $v0      # salva l'intero in $s0

# calcola fibonacci(n)
        move $a0, $s0       # Chiama la procedura con $a0 = n
        jal fib
        move $s1, $v0       # salva il valore restituito da fib in $s1

# stampa il risultato ed esci
        li $v0, 4           # stampa il messaggio di output
        la $a0, output
        syscall
        move $a0, $s1       # stampa il risultato
        li $v0, 1
        syscall

        li $v0, 10          # exit
        syscall

fib:
        addi $sp, $sp,-12   # crea uno spazio di 3 word nello stack
        sw $ra, 0($sp)      # salva l'indirizzo di ritorno della chiamata
        sw $a0, 4($sp)      # salva il valore di $a0 e $s0 che verranno usate
        sw $s0, 8($sp)      # dalla procedura ($t0 non viene salvato)

        li $t0, 2           # se n> 2 esegui ricorsione
        bgt $a0, $t0, ricorsione

        li $v0, 1           # altrimenti restituisci 1
        j return

ricorsione:
        addi $a0, $a0,-1    # n -> n-1
        jal  fib            # chiama fib(n-1)
        move $s0, $v0       # salva fib(n-1) in una variabile che non viene
                            # alterate dalla procedura
        addi $a0, $a0,-1    # $a0 diventa n-2
        jal  fib            # esegue fib(n-2)
        add  $v0, $v0, $s0  # somma  fib(n-1) e fib(n-2)

return:
        lw $ra, 0($sp)      # ripristina i vecchi valori di $ra
        lw $a0, 4($sp)      # $a0 e
        lw $s0, 8($sp)      # $s0
        addi $sp, $sp, 12   # disalloca lo spazio creato nello stack
        jr $ra              # ritorna al punto di chiamata


