# Programma dimostrativo dell'uso delle Jump Address Table
# per richiamare un set di procedure attraverso un indice
# (ex. syscall o switch)
         .data
lookup:  .space 12
msga:    .asciiz "Inserisci l'indice della procedura voluta[0..2]: "
msg1:    .asciiz "Esecuzione della prima procedura"
msg2:    .asciiz "Esecuzione della seconda procedura"
msg3:    .asciiz "Esecuzione della terza procedura"
         .text
         .globl main
main:
# carico la lookup table con i valori opportuni
         la $s0 , lookup   # $s0 contiene l'indirizzo della tabella lookup
         la $t0 , proc1    # salvo l'indirizzo dalla prima procedura
         sw $t0 , 0($s0)
         la $t0 , proc2    # salvo l'indirizzo dalla seconda procedura
         sw $t0 , 4($s0)
         la $t0 , proc3    # salvo l'indirizzo dalla terza procedura
         sw $t0 , 8($s0)

         li $v0 , 4        # stampo messaggio di richiesta
         la $a0 , msga
         syscall
         li $v0 , 5        # leggo un intero da console
         syscall           # numero in $v0

# calcolo l'indirizzo della procedura richiesta e la richiamo
         li $t0 , 4
         mul $t0 , $t0 , $v0   # $t0 = $vo * 4
         add  $t1 , $t0 , $s0  # $t1 = $t0 + lookup
         lw $t2 , 0($t1)       # $t2 = ($t1)
         jal $t2               # salto alla procedura

         li $v0, 10            # exit
         syscall

# set di procedure
proc1:   li $v0 , 4
         la $a0 , msg1
         syscall
         jr $ra

proc2:   li $v0 , 4
         la $a0 , msg2
         syscall
         jr $ra

proc3:   li $v0 , 4
         la $a0 , msg3
         syscall
         jr $ra
