# Programma che calcola la somma dei quadrati da 0 a N
# Dimostrativo dell'implementazione di cicli for 
# e dell'uso di istruzioni mul

	.data
msg:	.asciiz "Inserisci N "
str:	.asciiz "La somma dei quadrati da 0 a N vale "
	.text
	.globl main

main:
	li $v0, 4	# Stampo messaggio di richiesta
	la $a0, msg
	syscall

	li $v0 , 5	# Carico un intero da console
	syscall

	move $s0 , $v0	# $s0 contiene N
	li $s1, 0	# $s1 contiene la somma dei quadrati
	li $t0, 0	# $t0 e' l'indice di ciclo
Loop:
	mul $t1, $t0 , $t0	# calcolo il quadrato:	$t1 = $t0 x $t0
	addu $s1, $s1, $t1	# accumulo le somme:	$s0 += $t1
	addi $t0, $t0, 1	  # incremento l'indice	$t0++
	ble $t0, $s0, Loop	# se indice < N salta a Loop	if $t0<$s0 goto Loop
											# Questa istruzione viene tradotta usando un
											# salto relativo alla posizione del branch
											#   slt $at , $so , $t0
											#   beq $1 , $0 , -16
											# il l'offset viene calcolato sottraendo l'indirizzo
											# di arrivo del  salto conl'indirizzo dell'istruzione
											# di salto e dividendo per 4
											# in questo esempio Loop  rilocato in 0x040004 mentre
											# beq viene rilocato in 0x0400054. Da cui:
											# Loop - 0x0400044 = 16 -> 16/4=4 -> 100 in binario
											# 100 -> 0xfffc in complemento a 2

	li $v0, 4	# Stampo messaggio di output
	la $a0, str
	syscall

	li $v0, 1	# Stampo somma
	add $a0, $s1, $zero	# eq. alla pseudo-instr. move $a0 , $s1
	syscall

	li $v0, 10 			# $v0 codice della exit
	syscall			# esce dal programma

